/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model.multipart;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.AndCondition;
import net.minecraft.client.renderer.model.multipart.ICondition;
import net.minecraft.client.renderer.model.multipart.OrCondition;
import net.minecraft.client.renderer.model.multipart.PropertyValueCondition;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;

public class Selector {
    private final ICondition field_188167_a;
    private final VariantList field_188168_b;

    public Selector(ICondition iCondition, VariantList variantList) {
        if (iCondition == null) {
            throw new IllegalArgumentException("Missing condition for selector");
        }
        if (variantList == null) {
            throw new IllegalArgumentException("Missing variant for selector");
        }
        this.field_188167_a = iCondition;
        this.field_188168_b = variantList;
    }

    public VariantList func_188165_a() {
        return this.field_188168_b;
    }

    public Predicate<BlockState> func_188166_a(StateContainer<Block, BlockState> stateContainer) {
        return this.field_188167_a.getPredicate(stateContainer);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static class Deserializer
    implements JsonDeserializer<Selector> {
        public Selector deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            return new Selector(this.func_188159_b(jsonObject), (VariantList)jsonDeserializationContext.deserialize(jsonObject.get("apply"), VariantList.class));
        }

        private ICondition func_188159_b(JsonObject jsonObject) {
            if (jsonObject.has("when")) {
                return Deserializer.func_188158_a(JSONUtils.func_152754_s(jsonObject, "when"));
            }
            return ICondition.field_223246_a_;
        }

        @VisibleForTesting
        static ICondition func_188158_a(JsonObject jsonObject2) {
            Set set = jsonObject2.entrySet();
            if (set.isEmpty()) {
                throw new JsonParseException("No elements found in selector");
            }
            if (set.size() == 1) {
                JsonObject jsonObject2;
                if (jsonObject2.has("OR")) {
                    List list = Streams.stream((Iterable)JSONUtils.func_151214_t(jsonObject2, "OR")).map(jsonElement -> Deserializer.func_188158_a(jsonElement.getAsJsonObject())).collect(Collectors.toList());
                    return new OrCondition(list);
                }
                if (jsonObject2.has("AND")) {
                    List list = Streams.stream((Iterable)JSONUtils.func_151214_t(jsonObject2, "AND")).map(jsonElement -> Deserializer.func_188158_a(jsonElement.getAsJsonObject())).collect(Collectors.toList());
                    return new AndCondition(list);
                }
                return Deserializer.func_188161_b((Map.Entry)set.iterator().next());
            }
            return new AndCondition(set.stream().map(Deserializer::func_188161_b).collect(Collectors.toList()));
        }

        private static ICondition func_188161_b(Map.Entry<String, JsonElement> entry) {
            return new PropertyValueCondition(entry.getKey(), entry.getValue().getAsString());
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

